qui {

noi {
	/***********************************************************************************/
	/***** Step 2.10. Identify NICs, their year of independence and data availability */
	/**********************************************************************************/
}
	
	* Load data
	cd ..
	cd "./3. Intermediary results"
	use IDD1_p, clear
	
	* Keep relevent independence years
	keep if independence_years == 1 | independence_years == 5 | independence_years == 10 | independence_years == 20 | independence_years == 30
	drop if TDIDD == .
	keep TDIDD pvalue independence_years cntrycode cntry
	
	global country_results 1 5 10 20 30
	
	* Generate variables 
	gen str TDIDD_str = ""
	label var TDIDD_str "Independence dividend"
	
	* Correct some country names for .tex table
	replace cntry =  subinstr(cntry, "&", "\&",.)
	replace cntry = "Serbia" if cntry == "ZzSerbia"
	replace cntry = "Lesotho" if cntry == "Basutoland (Lesotho)"
	replace cntry = "Rwanda" if cntry == "Ruanda"
	
	gen DiD = string(round(TDIDD,.001),"%3.2f")
	replace TDIDD_str = DiD if pvalue > .1
	replace TDIDD_str = DiD +"$^{*}$" if pvalue > .05 & pvalue <= .1
	replace TDIDD_str = DiD +"$^{**}$" if pvalue > .01 & pvalue <= .05
	replace TDIDD_str = DiD +"$^{***}$" if pvalue <= .01
	
	* Report yearly estimates horizontally (instead of vertically)
	foreach year in $country_results {
		preserve
		keep if independence_years == `year'
		keep cntry TDIDD_str
		rename TDIDD_str TDIDD_str`year'
		cd ..
		cd ".\3. Intermediary results"
		sort cntry
		drop if cntry == ""
		save results_`year', replace
		restore
		}
	
	foreach year in $country_results {
		cd ..
		cd ".\3. Intermediary results"
		if `year' == 1 {
			use results_`year', clear
			sort cntry
			}
		if `year' != 1 {
			merge cntry using results_`year'
			drop _merge
			sort cntry
			}	
		erase results_`year'.dta
		}
		
	* Drop missing estimates 
	drop if TDIDD_str1 == ""

	* Export results
	order cntry TDIDD_str1 TDIDD_str5 TDIDD_str10 TDIDD_str20 TDIDD_str30

	cd ..
	cd "./5. TeX results"
	listtab ///
	using tableA4.tex,  replace ///
	rstyle(tabular) ///
	headlines("\begin{longtable}{lccccl} \caption{\textbf{Semi-parametric estimates of the economic impact of secession}} \label{tableA3} \\ \toprule \textbf{Country} & \textbf{$ T_{0}$ + 1} & \textbf{$ T_{0}$ + 5} & \textbf{$ T_{0}$ + 10}  & \textbf{$ T_{0}$ + 20}  & \textbf{$ T_{0}$ + 30}   \\ \midrule \endfirsthead \multicolumn{6}{l}{\textit{continued}} \\ \toprule  \textbf{Country} & \textbf{$ T_{0}$ + 1} & \textbf{$ T_{0}$ + 5} & \textbf{$ T_{0}$ + 10}  & \textbf{$ T_{0}$ + 20}  & \textbf{$ T_{0}$ + 30}  \\ \midrule \endhead \multicolumn{6}{l}{\textit{continued on next page}} \\ \endfoot \multicolumn{6}{l}{\begin{minipage}{0.95\linewidth}\vspace{0.1cm} \footnotesize \textbf{Note}: This table reports country-specific, semi-parametric estimates of the independence dividend. Results are reported for all available NICs and pertain to the 1$^{st}$, 5$^{th}$ and 20$^{th}$ year after independence respectively. Columns headed by $\hat{\beta}_{jt}$ report the estimated percentage difference between per capita GDP for the NIC listed in the first column and its synthetic control version, corresponding to equation \ref{eq:synthestimator}; columns headed by $\hat{\beta}_{jt}^{tDD}$ report the trend-demeaned independence dividend estimate, net of its 10-yearly pre-independence average, as outlined in equation \ref{eq:DiD} ; columns headed by $\hat{\beta}_{jt}^{DDD}$ report the trend- and placebo-demeaned independence dividend estimate, as defined in equation \ref{eq:DiDiD} ; columns headed by $\hat{\beta}_{jt}^{pure}$ report the quadruple independence dividend estimate, as defined in equation \ref{eq:pure}. Standard errors are robust against heteroskedasticity and serial correlation at the country level. Bootstrapped standard errors of the pure independence dividend based on 250 replications. The number of years after secession is indicated on the horizontal axis. \\ *** p$<$0.01, ** p$<$0.05, * p$<$0.1.  \end{minipage}}\\ \endlastfoot") ///
	footlines("\bottomrule \end{longtable}")
		
	* Reroute to directory containing dofiles
	cd ..
	cd ".\1. Dofiles"
	}
